#ifndef _ANN_H_
#define _ANN_H_

#include <fstream.h>	// for ANN::OutputWeights
#include "COb.DLList.h" // created with: genclass COb val DLList
#include "COb.XPlex.h"  // created with: genclass COb val Plex 
//                                     & genclass COb val XPlex


#define ACTIVITY_TYPE double
#define WEIGHT_TYPE   double

class NeuronActivity
{
public:
  
  // data members
  ACTIVITY_TYPE activity;
  
  // constructor
  NeuronActivity(ACTIVITY_TYPE a);
  
  // destructor
  ~NeuronActivity();
};

class Neuron
{
  friend class ANN;
  friend class Layer;
  friend class Synapse;
  
protected:
  
  // data members
  CObXPlex      dendrite;       // an array of incoming Synapses (influencing this Neuron).
  ACTIVITY_TYPE	activity;
  
  // constructor
  Neuron();
  
  // destructor
  ~Neuron();
};

class Synapse
{
  friend class ANN;
protected: 
  
  // data members
  Neuron*     p_from_neuron;
  WEIGHT_TYPE weight, summedWeightChange;
  
  // constructor
  Synapse(Neuron* pFN);
  
  // destructor
  ~Synapse();
  
  // this function computes the weighted ouput value produced from this synapse.
  ACTIVITY_TYPE Influence();
};

	
class Layer
{
  friend class ANN;
  
protected:
  
  // data members
  CObXPlex neurons;
  
  // constructor
  Layer();
  
  // destructor
  ~Layer();
};  

class ANN
{
protected:
  
  // data members
  CObDLList   layers;
  CObXPlex  summedWeightChanges;
  int       n_samples_analyzed;
  
  // a threshold function
  ACTIVITY_TYPE SigmoidActivationFunction( ACTIVITY_TYPE x );
  
public:
  
  // constructor
  ANN(int n_neurons_in_input_layer, int n_neurons_in_output_layer);
  
  // destructor
  ~ANN();
  
  // add a hidden layer to the network.  (This is a way to specify how many neurons there are in each
  // hidden layer, without having to have a variable number of parameters in the ANN constructor).
  void AddHiddenLayer(int n_neurons_in_hidden_layer);
  
  // Use this to compute the weight changes for the sample input (and add them to the 
  // running total for the previously "analyzed" training samples).
  void Analyze(CObXPlex* sample, CObXPlex* desiredOutput, double rate);
  
  // this member function is used to actually change the weights for the network.
  // Use this after all the training examples have been 'Analyze'd.
  void Train();
  
  // use evaluate to find the result of running the given sample through the net.
  CObXPlex* Evaluate(CObXPlex* sample);

  // output the current weights of the network  
  void OutputWeights(fstream& outStream);
};


#endif
